@extends('user.layouts.master')
@section('css')
    <link href="{{ asset('frontend/user/assets/css/nucleo.css') }}" id="app-style" rel="stylesheet" type="text/css">
    <link href="{{ asset('frontend/user/assets/css/fontawesome-all.css') }}" id="app-style" rel="stylesheet" type="text/css">
    <link href="{{ asset('frontend/user/assets/css/argon.css') }}" id="app-style" rel="stylesheet" type="text/css">
    <link href="{{ asset('frontend/user/assets/css/myapp.css') }}" id="app-style" rel="stylesheet" type="text/css">
    <style>
        .container-fluid {
            padding-right: 0px;
            padding-left: 0px;
        }
        
        .ads-rate-area{
            padding: 0.375rem 0.75rem;
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
            display: flex;
            justify-content: space-between;
        }
        .ads-rate-area-active{
            border: 1px solid #31bd21 !important;
        }
        
        .package-area img{
            width: 100%;
            height: 165px;
        }
        
        .cost-area{
            background: #4285f4;
            padding: 6px 8px;
            border-radius: 3px;
            color: #ffffff;
        }
        
        .cost_currency{
            position: relative;
            bottom: 6px;
            font-size: 12px;
            margin-left: 5px;
        }
    </style>
@endsection
@section('user-content')

    <div class="card card-body mt-2 p-3" style="background-color: rgb(248, 249, 254);height: auto !important;">
        <div class="card-header row">
            
        </div>
        <div class="row justify-content-center">
            @foreach($datas as $data)
                <div class="col-md-6 data-area">
                    <div class="card">
                        <div class="card-header bg-primary text-white text-center">
                            <h2 class="text-white">{{$data->name}}</h2>
                        </div>
                        <div class="card-body Promoter Award_body">
                            @php
                                $features = explode("|",$data->features);
                            @endphp
                            <span style="color: #3498DB" ;="">
                                @foreach($features as $f_key=>$feature)
                                    <p><i class="fas fa-check-circle text-blue"></i>&nbsp;&nbsp; {{$feature}}</p>
                                @endforeach
                
                                @if(Auth::user()->premium_status == 1 && Auth::user()->premium_package_id == $data->id)
                                    <div class="text-center">
                                        <hr>
                                        <button class="btn btn-danger">Active</button>
                                    </div>
                                @else
                                    <div class="text-center">
                                        <hr>
                                        @if(Auth::user()->deposit_balance >= $data->cost)
                                            <button class="btn btn-primary" onclick="buySelect('{{$data->id}}', '{{$data->duration}}', '{{$data->cost}}')">Buy Subscription at ${{$data->cost}}</button>
                                        @else
                                            <button class="btn btn-primary" onclick="alertBuySelect()">Buy Subscription at ${{$data->cost}}</button>
                                        @endif
                                    </div>
                                @endif
                
                            </span>
                        </div>
                    </div>
                </div>
            @endforeach
            
            <div class="modal fade" id="modalBuy" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        
                        <div class="modal-body">
                            <h3>Are you confirm to buy Premium Subscription?</h3>
                            <br>
                            <input type="hidden" id="txt_pkg_id_val">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Duration</th>
                                        <th>Cost</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><span id="txt_pkg_duration">0</span> Days <input type="hidden" id="txt_pkg_duration_val"></td>
                                        <td><span id="txt_pkg_price">0</span> USD <input type="hidden" id="txt_pkg_price_val"</td>
                                    </tr>
                                </tbody>
                            </table>
                
                            <br>
                
                            <div class="alert alert-dismissible" style="display:none;" role="alert" id="topAlertMainDeposit">
                               <span class="alert-text"><strong><span id="error-text-deposit"></span></strong></span>
                            </div>
                         </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-success" id="btnBuyConfirm">Yes, Confirm</button>
                            <button type="button" class="btn btn-default" onclick="closeModal()">No</button>
                        </div>
                    </div>
                </div>
           </div>
           
            <div class="modal fade" id="modalBuyAlert" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        
                        <div class="modal-body">
                            <h3>You have no sufficient balance to buy subscription! Please deposit and buy this subscription</h3>
                         </div>
                        <div class="modal-footer">
                            <a href="{{route('user.deposit')}}" class="btn btn-success" id="btnBuyConfirm">Deposit</a>
                            <button type="button" class="btn btn-default" onclick="closeAlertModal()">Close</button>
                        </div>
                    </div>
                </div>
           </div>
        </div>
    </div>

@endsection
@section('js')
    <script>
        function filterItem(){
            var value = $('#filter_item').val().toLowerCase();
            $(".data-area").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        }
    
        function alertBuySelect(){
            $('#modalBuyAlert').modal('toggle');
        }
        
        function closeAlertModal(){
            $('#modalBuyAlert').modal('toggle');
        }
    
        function buySelect(package_id, premium_duration,premium_user_cost){
            $('#topAlertMainDeposit').hide();
            $('#txt_pkg_id_val').val(package_id);
            $('#txt_pkg_duration').text(premium_duration);
            $('#txt_pkg_duration_val').val(premium_duration);
            $('#txt_pkg_price').text(premium_user_cost);
            $('#txt_pkg_price_val').val(premium_user_cost);
            $('#modalBuy').modal('toggle');
        }
        
        function closeModal(){
            $('#modalBuy').modal('toggle');
        }
        
        $(document).on('click', '#btnBuyConfirm', function () {
            let tho = $(this);
            tho.prop('disabled', true);
            
            var txt_pkg_id = $('#txt_pkg_id_val').val();
            var premium_duration = $('#txt_pkg_duration_val').val();
            var premium_user_cost = $('#txt_pkg_price_val').val();

            jQuery.ajax({
                url: "{{ route('user.active-premium') }}",
                type: "POST",
                data: {_token: '{{csrf_token()}}',txt_pkg_id: txt_pkg_id,premium_duration: premium_duration,premium_user_cost:premium_user_cost},
                success: function (data) {
                    // console.log(data);
                    if (data.error == 1) {
                        responseMessage(0, data);
                    } else {
                        responseMessage(1, data);
                        setTimeout(function(){
                            location.reload();
                        }, 2000);
                    }
                    tho.prop('disabled', false);
                },
                error: function (data) {
                    tho.prop('disabled', false);
                }
            });
        });
        
        function responseMessage(type, msg) {
            const topAlertMainDeposit = $('#topAlertMainDeposit');
            const error_text_deposit = $('#error-text-deposit');
            switch (type) {
                case 1:
                    topAlertMainDeposit.removeClass('alert-danger');
                    topAlertMainDeposit.addClass('alert-success');
                    error_text_deposit.text(msg);
                    topAlertMainDeposit.fadeIn();
                    break;
                case 0:
                    topAlertMainDeposit.removeClass('alert-success');
                    topAlertMainDeposit.addClass('alert-danger');
                    error_text_deposit.text(msg);
                    topAlertMainDeposit.fadeIn();
                break;
            }
        }
    </script>
@endsection
